<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["Deposit"]) && empty($data["Withdraw"])) {
        echo json_encode([
            "status" => "error",
            "message" => "Deposit or Withdraw value required"
        ]);
        exit;
    }

    $Deposit  = trim($data["Deposit"] ?? "");
    $Withdraw = trim($data["Withdraw"] ?? "");

    $sql = "INSERT INTO `minimum` (`id`, `Deposit`, `Withdraw`)
            VALUES (1, ?, ?)
            ON DUPLICATE KEY UPDATE
                `Deposit` = VALUES(`Deposit`),
                `Withdraw` = VALUES(`Withdraw`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $Deposit, $Withdraw);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Minimum amount updated"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed"
        ]);
    }

    $stmt->close();
}
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `minimum` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status"   => "success",
            "Deposit"  => $row["Deposit"],
            "Withdraw" => $row["Withdraw"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No data found"
        ]);
    }
}

$conn->close();
?>