<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (
        empty($data["VersionCode"]) &&
        empty($data["UpdateLink"]) &&
        empty($data["UpdateNotice"]) &&
        empty($data["Application"]) &&
        empty($data["ClosedReason"]) &&
        empty($data["ApiKey"]) &&
        empty($data["AddMoney"])
    ) {
        echo json_encode(["status" => "error", "message" => "At least one field is required"]);
        exit;
    }

    $VersionCode   = trim($data["VersionCode"] ?? "");
    $UpdateLink    = trim($data["UpdateLink"] ?? "");
    $UpdateNotice  = trim($data["UpdateNotice"] ?? "");
    $Application   = trim($data["Application"] ?? "");
    $ClosedReason  = trim($data["ClosedReason"] ?? "");
    $ApiKey        = trim($data["ApiKey"] ?? "");
    $AddMoney      = trim($data["AddMoney"] ?? "");

    $sql = "INSERT INTO `info`
            (`id`, `VersionCode`, `UpdateLink`, `UpdateNotice`, `Application`, `ClosedReason`, `ApiKey`, `AddMoney`)
            VALUES (1, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                `VersionCode` = VALUES(`VersionCode`),
                `UpdateLink` = VALUES(`UpdateLink`),
                `UpdateNotice` = VALUES(`UpdateNotice`),
                `Application` = VALUES(`Application`),
                `ClosedReason` = VALUES(`ClosedReason`),
                `ApiKey` = VALUES(`ApiKey`),
                `AddMoney` = VALUES(`AddMoney`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "sssssss",
        $VersionCode,
        $UpdateLink,
        $UpdateNotice,
        $Application,
        $ClosedReason,
        $ApiKey,
        $AddMoney
    );

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Saved successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Save failed"]);
    }

    $stmt->close();
}

/* -------- GET DATA -------- */
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `info` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "VersionCode"  => $row["VersionCode"],
            "UpdateLink"   => $row["UpdateLink"],
            "UpdateNotice" => $row["UpdateNotice"],
            "Application"  => $row["Application"],
            "ClosedReason" => $row["ClosedReason"],
            "ApiKey"       => $row["ApiKey"],
            "AddMoney"     => $row["AddMoney"]
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "No data found"]);
    }
}

$conn->close();
?>