<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["BKash"]) && empty($data["Nagad"]) && empty($data["Roket"]) && empty($data["Upay"])) {
        echo json_encode(["status" => "error", "message" => "At least one number is required"]);
        exit;
    }

    $BKash = trim($data["BKash"]);
    $Nagad = trim($data["Nagad"]);
    $Roket = trim($data["Roket"]);
    $Upay  = trim($data["Upay"]);

    $sql = "INSERT INTO `number` (`id`, `BKash`, `Nagad`, `Roket`, `Upay`) 
            VALUES (1, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                `BKash` = VALUES(`BKash`),
                `Nagad` = VALUES(`Nagad`),
                `Roket` = VALUES(`Roket`),
                `Upay` = VALUES(`Upay`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $BKash, $Nagad, $Roket, $Upay);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "success"
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed"
        ]);
    }

    $stmt->close();
}
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `number` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "BKash" => $row["BKash"],
            "Nagad" => $row["Nagad"],
            "Roket" => $row["Roket"],
            "Upay" => $row["Upay"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No data found"
        ]);
    }
}

$conn->close();
?>